Option Explicit

Global gsCurrDir As String   ' Current working directory
Global gsInitFile As String  ' Initialization File
Global gsInitSect As String  ' Initialization Section
Global gsInitDrv As String   ' Initialization file disk drive

Global gbAutoSync As Integer  ' Automatically Synchronize?
Global gbNtfyUser As Integer  ' Ask and Notify the User about copies and deletions?
Global gsRunDir As String     ' Working Directory for Run Command
Global gsRunCmd As String     ' Run Command string
Global gbSyncBoth As Integer  ' Run synchronization in both directions?
Global gbCopyOld As Integer   ' Copy older source files?
Global gbDelXtra As Integer   ' Delete extra target files?

Global gsLog As String  ' Activity log report string

Global gsCRLF As String  ' Carriage Return, Line Feed
Global gsLF As String    ' Line Feed


Declare Function GetPrivateProfileString Lib "KERNEL" (ByVal Section As String, ByVal Entry As String, ByVal Default As String, ByVal ReturnBuffer As String, ByVal ReturnBufferSize As Integer, ByVal FileName As String) As Integer


' SetAttr, Dir, GetAttr functions
Global Const ATTR_NORMAL = 0
Global Const ATTR_READONLY = 1
Global Const ATTR_HIDDEN = 2
Global Const ATTR_SYSTEM = 4
Global Const ATTR_VOLUME = 8
Global Const ATTR_DIRECTORY = 16
Global Const ATTR_ARCHIVE = 32

' Check Value
Global Const UNCHECKED = 0 ' 0 - Unchecked
Global Const CHECKED = 1   ' 1 - Checked
Global Const GRAYED = 2    ' 2 - Grayed

' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

Function bFileExists (ByVal vsFileName As String) As Integer
    Dim sTime As String

    On Error Resume Next  ' See if file exists
	sTime = FileDateTime(vsFileName)
	If Err = 0 Then
	    bFileExists = True
	Else
	    bFileExists = False
	End If
    On Error GoTo 0
End Function

Sub ExecuteRunCommand ()
    Dim hInsc As Integer  ' Handle to program instance
    Dim sDrv As String

    If gsRunCmd <> "" Then
	On Error Resume Next
	    If gsRunDir <> "" Then  ' Set working directory
		If InStr(gsRunDir, ":") > 0 Then
		    sDrv = Left$(gsRunDir, 1)
		    ChDrive (sDrv)
		End If
		ChDir (gsRunDir)
	    End If

	    hInsc = Shell(gsRunCmd, 1)' Run program normally
	    If Err <> 0 Then
		Beep
		MsgBox "Could not execute command:" & gsLF & gsRunCmd & gsLF & Error$, MB_ICONINFORMATION, "Directory Synchronization Utility"
	    End If
	On Error GoTo 0
    End If
End Sub

Sub InitializeLogText ()
    Dim dCurrTime  ' Variant (date)

    dCurrTime = Now
    gsLog = "Directory Synchronization Utility run on " & Format(dCurrTime, "d-mmm-yyyy") & " at " & Format(dCurrTime, "h:nnam/pm")
End Sub

Sub Main ()
    Dim sCmd As String
    Dim i As Integer

    gsCRLF = Chr$(13) & Chr$(10)  ' Pseudo constant (carriage-return, line-feed)
    gsLF = Chr$(10)

    gsCurrDir = CurDir$
    If Right$(gsCurrDir, 1) <> "\" Then
	gsCurrDir = gsCurrDir & "\"
    End If

    sCmd = Trim$(Command$)  ' Command line argument(s)
    i = InStr(sCmd, " ") ' InitFile InitSect
    If i = 0 Then
	gsInitFile = sCmd
	gsInitSect = "SyncDir"  ' Default name
    Else
	gsInitFile = Left$(sCmd, (i - 1))
	gsInitSect = Trim$(Mid$(sCmd, (i + 1)))  ' Rest of string
    End If

    If gsInitFile = "" Then
	gsInitFile = gsCurrDir & "SyncDir.ini"
	If Not bFileExists(gsInitFile) Then
	    gsInitFile = ""
	End If
    ElseIf Not bFileExists(gsInitFile) Then
	Beep
	MsgBox "Could not open initialization file " & UCase$(gsInitFile), MB_ICONINFORMATION, "Directory Synchronization Utility"
	gsInitFile = ""
    End If
    
    gsInitDrv = Left$(gsCurrDir, 2)
    If InStr(gsInitFile, ":") = 2 Then
	gsInitDrv = Left$(gsInitFile, 2)
    End If

    gbAutoSync = False
    gbNtfyUser = True
    gbCopyOld = False
    gbDelXtra = False

    Load frmMain  ' Will finish reading initialization file
End Sub

Function nSynchronizeDirectories (ByVal vbCopyOld As Integer, ByVal vbDelXtra As Integer, ByVal vsSrcDir As String, ByVal vsTrgtDir As String, ByVal vsIgnrType As String) As Integer
    Dim nCopy As Integer     ' # files copied
    Dim nDel As Integer      ' # files deleted
    Dim sMsg As String       ' MsgBox message string
    Dim uRslt As Integer     ' MsgBox result code
    Dim bSync As Integer     ' User chose to synchronize?
    Dim sIgnrType As String  ' File types (extensions) to ignore

    bSync = True

    sIgnrType = UCase$(vsIgnrType)
    If sIgnrType <> "" Then
	sIgnrType = "," & sIgnrType & ","  ' Allow searches for ",XXX," file type
    End If

    ' Make a pass, without actually synchronizing
    Call SynchronizeFiles(False, vbCopyOld, vbDelXtra, vsSrcDir, vsTrgtDir, sIgnrType, nCopy, nDel)
    If (nCopy > 0) Or (nDel > 0) Then
	sMsg = "In order to synchronize target directory " & UCase$(vsTrgtDir) & " with source directory " & UCase$(vsSrcDir) & ", " & LTrim$(Str$(nCopy)) & " file(s) will be copied"
	If nDel > 0 Then
	    sMsg = sMsg & " and " & LTrim$(Str$(nDel)) & " file(s) will be deleted"
	End If
	sMsg = sMsg & "."

	If gbAutoSync And (Not gbNtfyUser) Then
	    uRslt = IDOK
	Else
	    uRslt = MsgBox(sMsg, (MB_ICONQUESTION + MB_OKCANCEL), "Directory Synchronization Utility")
	End If
	If uRslt = IDOK Then
	    DoEvents  ' Allow forms refresh
	    ' Make a second pass, actually synchronizing this time
	    Call SynchronizeFiles(True, vbCopyOld, vbDelXtra, vsSrcDir, vsTrgtDir, sIgnrType, nCopy, nDel)
	Else
	    bSync = False
	End If
    End If
    
    nSynchronizeDirectories = nCopy + nDel
    
    If Not bSync Then
	nSynchronizeDirectories = 0
    ElseIf (Not gbAutoSync) And (nCopy = 0) And (nDel = 0) Then
	MsgBox "Directory " & UCase$(vsTrgtDir) & " already matched directory " & UCase$(vsSrcDir), MB_ICONINFORMATION, "Directory Synchronization Utility"
    End If
End Function

Function sInitializationEntry (ByVal vsName As String, ByVal vsDflt As String) As String
    Dim sBuff As String      ' Character buffer for Windows API function call
    Dim nBuffLen As Integer  ' Buffer length returned by Windows API function

    If gsInitFile = "" Then
	sInitializationEntry = vsDflt
    Else
	sBuff = String$(255, Chr$(0))  ' Pre-allocate the buffer
	nBuffLen = GetPrivateProfileString(gsInitSect, vsName, vsDflt, sBuff, Len(sBuff), gsInitFile)
	sInitializationEntry = UCase$(Left$(sBuff, nBuffLen))
    End If
End Function

Sub SynchronizeFiles (ByVal vbExec As Integer, ByVal vbCopyOld As Integer, ByVal vbDelXtra As Integer, ByVal vsSrcDir As String, ByVal vsTrgtDir As String, ByVal vsIgnrType As String, rnCopy As Integer, rnDel As Integer)
    Dim sSrc As String   ' Local copy of Source directory name
    Dim sTrgt As String  ' Local copy of Target directory name
    Dim sFile As String  ' Current filename
    Dim sType As String  ' Current file's type (extension)
    Dim sSrcTime As String   ' Source file timestamp
    Dim sTrgtTime As String  ' Target file timestamp
    Dim bErr As Integer  ' Error in processing
    Dim bCncl As Integer  ' User requested Cancel
    Dim uRslt As Long
    Dim s As String

    bErr = False
    bCncl = False
    
    Screen.MousePointer = 11  ' Hourglass
    sSrc = vsSrcDir
    If Right$(sSrc, 1) <> "\" Then
	sSrc = sSrc & "\"
    End If

    sTrgt = vsTrgtDir
    If Right$(sTrgt, 1) <> "\" Then
	sTrgt = sTrgt & "\"
    End If

    rnCopy = 0
    rnDel = 0
    
    If vbExec Then  ' This is the actual execution pass
	gsLog = gsLog & gsCRLF & gsCRLF & "Synchronizing files:" & gsCRLF & "  Source: """ & sSrc & "*.*""" & gsCRLF & "  Target:  """ & sTrgt & "*.*"""
	
	If vbCopyOld Then
	    gsLog = gsLog & gsCRLF & gsCRLF & "Copying different source files ..."
	Else
	    gsLog = gsLog & gsCRLF & gsCRLF & "Copying newer source files ..."
	End If
    End If

    On Error Resume Next
	s = Dir$(sTrgt, ATTR_DIRECTORY)  ' Should return "." directory entry
	If (s = "") Or (Err <> 0) Then
	    Beep
	    MsgBox "Not a valid target directory: """ & sTrgt & """", MB_ICONEXCLAMATION, "Directory Synchronization Utility"
	    bErr = True
	End If
    On Error GoTo 0

    On Error Resume Next
	sFile = Dir$(sSrc & "*.*")  ' This also primes the While loop call to Dir$
	If Err <> 0 Then
	    Beep
	    MsgBox "Not a valid source directory: """ & sSrc & """", MB_ICONEXCLAMATION, "Directory Synchronization Utility"
	    bErr = True
	End If
    On Error GoTo 0
    
    While (Not bErr) And (Not bCncl) And (sFile <> "")
	sType = UCase$(Mid$(sFile, (1 + InStr(sFile, "."))))  ' Get file type (without ".")
	If (vsIgnrType <> "") And (InStr(vsIgnrType, ("," & sType & ",")) > 0) Then
	    If vbExec Then
		gsLog = gsLog & gsCRLF & "  (Ignored file """ & sFile & """)"
	    End If
	Else
	    sSrcTime = Format(FileDateTime(sSrc & sFile), "yyyymmdd.hhnnss")
    
	    On Error Resume Next
		sTrgtTime = Format(FileDateTime(sTrgt & sFile), "yyyymmdd.hhnnss")
		If Err <> 0 Then
		    sTrgtTime = ""
		End If
	    On Error GoTo 0
	    
	    If vbCopyOld And (sSrcTime = sTrgtTime) Then
		If vbExec Then
		    gsLog = gsLog & gsCRLF & "  (""" & sFile & """ matched the source file)"
		End If
	    ElseIf (Not vbCopyOld) And (sSrcTime <= sTrgtTime) Then
		If vbExec Then
		    gsLog = gsLog & gsCRLF & "  (""" & sFile & """ was up to date)"
		End If
	    Else
		rnCopy = rnCopy + 1
		If vbExec Then
		    On Error Resume Next
			FileCopy (sSrc & sFile), (sTrgt & sFile)
			If Err = 0 Then
			    gsLog = gsLog & gsCRLF & "  Copied file """ & sFile & """"
			Else
			    Beep
			    uRslt = MsgBox(Error$, (MB_ICONEXCLAMATION + MB_OKCANCEL), ("Error copying file """ & sFile & """"))
			    gsLog = gsLog & gsCRLF & "  *** Error copying file """ & sFile & """" & gsCRLF & "      " & Error$
			    If uRslt = IDCANCEL Then
				bCncl = True
				gsLog = gsLog & gsCRLF & "*** Directory synchronization cancelled at user request"
			    End If
			End If
		    On Error GoTo 0
		End If
	    End If  ' Else copied file
	End If ' Else not ignoring file
	
	sFile = Dir$  ' Get next matching file

	DoEvents  ' Be a good Windows citizen
	Screen.MousePointer = 11  ' Hourglass
    Wend
    
    If (Not bErr) And (Not bCncl) And vbDelXtra Then
	If vbExec Then
	    gsLog = gsLog & gsCRLF & gsCRLF & "Deleting extra target files ..."
	End If

	On Error Resume Next
	    sFile = Dir$(sTrgt & "*.*")
	    If Err <> 0 Then
		Beep
		MsgBox "Not a valid target directory: """ & sTrgt & """", MB_ICONEXCLAMATION, "Directory Synchronization Utility"
		bErr = True
	    End If
	On Error GoTo 0
	
	While (Not bErr) And (Not bCncl) And (sFile <> "")
	    sType = UCase$(Mid$(sFile, (1 + InStr(sFile, "."))))  ' Get file type (without ".")
	    If (vsIgnrType <> "") And (InStr(vsIgnrType, ("," & sType & ",")) > 0) Then
		If vbExec Then
		    gsLog = gsLog & gsCRLF & "  (Ignored extra file """ & sFile & """)"
		End If
	    Else
		sTrgtTime = Format(FileDateTime(sTrgt & sFile), "yyyymmdd.hhnnss")
	
		On Error Resume Next
		    sSrcTime = Format(FileDateTime(sSrc & sFile), "yyyymmdd.hhnnss")
		    If Err <> 0 Then
			sSrcTime = ""
		    End If
		On Error GoTo 0
		
		If sSrcTime = "" Then
		    rnDel = rnDel + 1
		    If vbExec Then
			On Error Resume Next
			    Kill (sTrgt & sFile)
			    If Err = 0 Then
				gsLog = gsLog & gsCRLF & "  Deleted file """ & sFile & """"
			    Else
				Beep
				uRslt = MsgBox(Error$, (MB_ICONEXCLAMATION + MB_OKCANCEL), ("Error deleting file """ & sFile & """"))
				gsLog = gsLog & gsCRLF & "  *** Error deleting file """ & sTrgt & sFile & """" & gsCRLF & "      " & Error$
				If uRslt = IDCANCEL Then
				    bCncl = True
				    gsLog = gsLog & gsCRLF & "*** Directory synchronization cancelled at user request"
				End If
			    End If
			On Error GoTo 0
		    End If
		End If
	    End If  ' Else not an ignored file type
	    
	    sFile = Dir$  ' Get next matching file
	Wend
    End If

    Screen.MousePointer = 0

    If bErr Then
	rnCopy = -1
	rnDel = -1
    End If
End Sub

